// // // // // // // // // // // // // // // // // // // //
//	
//	Sensor
//	
//	created Apr/14/98 by Andreas Warnke
//	last mod Mai/17/98 by Andreas Warnke
//	
//	This class receives status-messages from
//	the Server and calls the appropiate 
//	virtual methods.
//



// // // // // // // // // // // // // // // // // // // //
//	
//	#pragma once
//

#ifndef Sensor_h_
#define Sensor_h_



// // // // // // // // // // // // // // // // // // // //
//	
//	#include
//

#include <Be.h>
#include "ConnectionData.h"



// // // // // // // // // // // // // // // // // // // //
//	
//	Sensor Declaration
//

class Sensor : public virtual BLooper, protected virtual ConnectionData
{
protected:
	//	Evaluation of received Messages:
	//	Normally it's not necessary to override these 4 functions,
	//	because they extract all available data from the message.
	//	But the SimpleReflexAgent will override StatusMessageReceived()
	//	because this agent has no memory to store the received data.
	virtual void WelcomeMessageReceived ( BMessage * inMessage );
	virtual void StatusMessageReceived ( BMessage * inMessage );
	virtual void VictoryMessageReceived ( BMessage * inMessage );
	virtual void ErrorMessageReceived ( BMessage * inMessage );
	
protected:
	//	Methods that are called, when a Message was received:
	//	Welcome - Methods:
	virtual void ProtocolVersionReceived (
		unsigned int inVersion ) {};
	virtual void ClientIDReceived (
		unsigned int inID ) {};
	virtual void MapSizeReceived (
		unsigned int inWidth,
		unsigned int inHeight ) {};
	//	Error - Methods:
	virtual void ErrorReceived (
		int inCode,
		const char * inText ) {};
	//	Status - Methods:
	virtual void ServerTimeReceived (
		bigtime_t inTime ) {};
	virtual void VisibleFieldReceived (
		int inX,
		int inY,
		unsigned int inType ) {};
	virtual void InvisibleFieldReceived (
		int inX,
		int inY ) {};
	virtual void ObjectReceived (
		unsigned int inID,
		unsigned int inType,
		unsigned int inOwnerID,
		bigtime_t inBusyTill,
		bool inBusy,
		int inX,
		int inY,
		bool inCompleteSensorData ) {};
	//	Victory - Methods:
	virtual void VictoryReceived (
		unsigned int inWinnerID,
		const char * inWinnerName ) {};
	
	//	Constructor
	Sensor ();
	
	//	Destructor
	virtual ~Sensor ();
	
	//	MessageReceived:
	virtual void MessageReceived ( BMessage * inMessage );
	
	//	Count all waiting messages
	//	to determine, if there is time to calculate a good move.
	static unsigned int CountAllWaitingMessages ( team_id inTeam );
};



#endif



//	
//	The End.
//	
// // // // // // // // // // // // // // // // // // // //